-- MySQL dump 10.13  Distrib 5.6.42, for Linux (x86_64)
--
-- Host: localhost    Database: vogacoil_laravel
-- ------------------------------------------------------
-- Server version	5.5.60-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_links`
--

DROP TABLE IF EXISTS `admin_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_link` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_count` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_links`
--

LOCK TABLES `admin_links` WRITE;
/*!40000 ALTER TABLE `admin_links` DISABLE KEYS */;
INSERT INTO `admin_links` VALUES (1,'ddd.com','',0,'2018-12-08 14:21:50','2018-12-08 14:21:50'),(3,'https://riverfish.com.ua/ru','35c5d3992dc084',118,'2019-02-08 06:10:58','2020-02-23 05:15:54'),(4,'goo.gl','45c5d4e346b790',103,'2019-02-08 07:39:00','2020-02-23 05:16:07'),(5,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','55c5d61c2c8c1f',55,'2019-02-08 09:02:26','2020-02-08 00:39:34'),(6,'https://www.google.com/search?q=fashion&source=lnms&tbm=isch&sa=X&ved=0ahUKEwix3fG3gKzgAhWDiaYKHWVKCbEQ_AUIDigB','65c5d640d92e73',75,'2019-02-08 09:12:13','2020-02-17 13:15:22'),(7,'https://www.google.com/','75c5d73844963e',99,'2019-02-08 10:18:12','2020-02-23 05:16:07');
/*!40000 ALTER TABLE `admin_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `article_hash_tag`
--

DROP TABLE IF EXISTS `article_hash_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `article_hash_tag` (
  `article_id` int(10) unsigned NOT NULL,
  `hash_tag_id` int(10) unsigned NOT NULL,
  KEY `article_hash_tag_article_id_foreign` (`article_id`),
  KEY `article_hash_tag_hash_tag_id_foreign` (`hash_tag_id`),
  CONSTRAINT `article_hash_tag_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `article_hash_tag_hash_tag_id_foreign` FOREIGN KEY (`hash_tag_id`) REFERENCES `hash_tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `article_hash_tag`
--

LOCK TABLES `article_hash_tag` WRITE;
/*!40000 ALTER TABLE `article_hash_tag` DISABLE KEYS */;
INSERT INTO `article_hash_tag` VALUES (1,2),(2,1),(3,2),(4,3),(5,3),(6,4),(7,1);
/*!40000 ALTER TABLE `article_hash_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `articles`
--

DROP TABLE IF EXISTS `articles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `articles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_alt` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin_link_id` int(10) unsigned DEFAULT NULL,
  `display_as_prime` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `articles_admin_link_id_foreign` (`admin_link_id`),
  CONSTRAINT `articles_admin_link_id_foreign` FOREIGN KEY (`admin_link_id`) REFERENCES `admin_links` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `articles`
--

LOCK TABLES `articles` WRITE;
/*!40000 ALTER TABLE `articles` DISABLE KEYS */;
INSERT INTO `articles` VALUES (1,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496239355c5d627fbf88e.jpg','מבלוגים','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,1,'2019-02-08 09:05:43','2019-02-08 09:07:10'),(2,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496239685c5d62a045f97.jpg','מבלוגים','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,1,'2019-02-08 09:06:11','2019-02-08 09:07:44'),(3,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496239855c5d62b11d5b6.jpg','מבלוגים','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,1,'2019-02-08 09:06:30','2019-02-08 09:07:21'),(4,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496240015c5d62c124007.jpg','ם נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,1,'2019-02-08 09:06:56','2019-02-08 09:06:56'),(5,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496240995c5d6323c7427.jpg','מבלוגים','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,0,'2019-02-08 09:08:26','2019-02-08 09:08:26'),(6,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496241245c5d633c3ead5.jpg','מבלוגים','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,0,'2019-02-08 09:09:23','2019-02-08 09:09:23'),(7,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','images/uploads/articles/2019/02/08/15496241855c5d637992dc5.jpg','מבלוגים','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',5,0,'2019-02-08 09:09:51','2019-02-08 09:09:51');
/*!40000 ALTER TABLE `articles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blog_hash_tag`
--

DROP TABLE IF EXISTS `blog_hash_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blog_hash_tag` (
  `blog_id` int(10) unsigned NOT NULL,
  `hash_tag_id` int(10) unsigned NOT NULL,
  KEY `blog_hash_tag_blog_id_foreign` (`blog_id`),
  KEY `blog_hash_tag_hash_tag_id_foreign` (`hash_tag_id`),
  CONSTRAINT `blog_hash_tag_blog_id_foreign` FOREIGN KEY (`blog_id`) REFERENCES `blogs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blog_hash_tag_hash_tag_id_foreign` FOREIGN KEY (`hash_tag_id`) REFERENCES `hash_tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blog_hash_tag`
--

LOCK TABLES `blog_hash_tag` WRITE;
/*!40000 ALTER TABLE `blog_hash_tag` DISABLE KEYS */;
INSERT INTO `blog_hash_tag` VALUES (1,2),(2,2),(3,2),(4,3),(5,3);
/*!40000 ALTER TABLE `blog_hash_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_keywords` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_on_main_page` tinyint(1) NOT NULL DEFAULT '0',
  `display_as_prime` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_category_id_foreign` (`category_id`),
  CONSTRAINT `blogs_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
INSERT INTO `blogs` VALUES (1,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','<p>בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו</p>','<p>בניגוד לטענה הרווחת,אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו</p>','בניגוד לטענה הרווחת, Lorem Ipsum אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','בניגוד לטענה הרווחת, סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','storage/blogs/2019/02/08/15496205135c5d552182ff3.jpg','בניגוד לטענה הרווחת, Lorem Ipsum אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו',1,1,'2019-02-08 08:08:38','2019-02-08 08:12:09',NULL),(2,'בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי.','<p>בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו</p>','<p>בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו</p>','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','storage/blogs/2019/02/08/15496205885c5d556ce0684.jpg','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו',1,0,'2019-02-08 08:10:12','2019-02-08 08:14:04',NULL),(3,'לפני הספירה. מה שהופך אותו','<p>בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו</p>','<p>בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו</p>','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו','storage/blogs/2019/02/08/15496208105c5d564a55aed.jpg','בניגוד לטענה הרווחת, אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו',1,0,'2019-02-08 08:13:42','2019-02-08 08:13:42',NULL),(4,'ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','<p>ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.</p>','<p>ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.</p>','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','storage/blogs/2019/02/08/15496244905c5d64aaa5d3f.jpg','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.',0,0,'2019-02-08 09:14:59','2019-02-08 09:14:59',2),(5,'ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','<p>ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.</p>','<p>ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.</p>','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.','storage/blogs/2019/02/08/15496245295c5d64d10a538.jpg','ארוגים כותנה קצרים להגדיר שמציעות צבעוניים בצורת שבט רקמה המפרט.',0,0,'2019-02-08 09:15:40','2019-02-08 09:15:40',3);
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `brands`
--

DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `brands`
--

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,'images/uploads/brands/2018/12/09/15443266705c0c8e0ee3cb5.jpg','בדיקה בדיקה','בדיקה בדיקה',0);
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_alt` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'3NxTM2bEIMI2','images/uploads/categories/2019/02/08/15496216055c5d5965e8b76.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',3,'2019-02-08 08:26:54','2019-02-08 08:35:34'),(2,'מבלוגים3','images/uploads/categories/2019/02/08/15496216545c5d5996c27b8.jpg','מבלוגים',1,'2019-02-08 08:27:37','2019-02-08 08:35:45'),(3,'מבלוגים','images/uploads/categories/2019/02/08/15496217105c5d59ce4a2b6.jpg','מבלוגים',0,'2019-02-08 08:28:39','2019-02-08 08:35:34'),(4,'1מבלוגים','images/uploads/categories/2019/02/08/15496217535c5d59f9e850b.jpg','מבלוגים',2,'2019-02-08 08:29:16','2019-02-08 08:35:45');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hash_tag_tattoo`
--

DROP TABLE IF EXISTS `hash_tag_tattoo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hash_tag_tattoo` (
  `tattoo_id` int(10) unsigned NOT NULL,
  `hash_tag_id` int(10) unsigned NOT NULL,
  KEY `hash_tag_tattoo_tattoo_id_foreign` (`tattoo_id`),
  KEY `hash_tag_tattoo_hash_tag_id_foreign` (`hash_tag_id`),
  CONSTRAINT `hash_tag_tattoo_hash_tag_id_foreign` FOREIGN KEY (`hash_tag_id`) REFERENCES `hash_tags` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hash_tag_tattoo_tattoo_id_foreign` FOREIGN KEY (`tattoo_id`) REFERENCES `tattoos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hash_tag_tattoo`
--

LOCK TABLES `hash_tag_tattoo` WRITE;
/*!40000 ALTER TABLE `hash_tag_tattoo` DISABLE KEYS */;
INSERT INTO `hash_tag_tattoo` VALUES (1,2),(2,2),(3,2),(4,2),(5,2),(6,1),(7,1);
/*!40000 ALTER TABLE `hash_tag_tattoo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hash_tags`
--

DROP TABLE IF EXISTS `hash_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hash_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hash_tags`
--

LOCK TABLES `hash_tags` WRITE;
/*!40000 ALTER TABLE `hash_tags` DISABLE KEYS */;
INSERT INTO `hash_tags` VALUES (1,'קעקועים תת ממד','2018-12-08 13:55:20','2018-12-08 13:55:20'),(2,'קעקועים פים','2018-12-08 13:55:31','2018-12-08 13:55:31'),(3,'קעקועים נשים','2018-12-08 13:55:41','2018-12-08 13:55:41'),(4,'קעקועים גברים','2018-12-08 13:55:52','2018-12-08 13:55:52');
/*!40000 ALTER TABLE `hash_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` int(10) unsigned NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `images_blog_id_foreign` (`blog_id`),
  CONSTRAINT `images_blog_id_foreign` FOREIGN KEY (`blog_id`) REFERENCES `blogs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2018_05_29_124617_create_permission_tables',1),(4,'2018_05_29_144831_create_sliders_table',1),(5,'2018_05_30_095611_create_admin_links_table',1),(6,'2018_05_30_142217_slider_type',1),(7,'2018_05_31_072307_create_hashtags_table',1),(8,'2018_05_31_074157_slider_fields',1),(9,'2018_05_31_080200_create_tattoos_table',1),(10,'2018_05_31_130850_create_images_table',1),(11,'2018_06_01_094052_create_articles_table',1),(12,'2018_06_01_130949_create_video_sliders_table',1),(13,'2018_06_01_144720_create_categories_table',1),(14,'2018_06_04_122535_create_subscribes_table',1),(15,'2018_06_04_140303_create_recommendations_table',1),(16,'2018_06_06_073304_add_recommendation_image_alt',1),(17,'2018_06_06_085848_article_hash_tags',1),(18,'2018_06_07_122240_create_brands_table',1),(19,'2018_06_11_071148_add_shop_image',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_permissions`
--

DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_permissions`
--

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_roles`
--

DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_roles`
--

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recommendation_colours`
--

DROP TABLE IF EXISTS `recommendation_colours`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recommendation_colours` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `recommendation_id` int(10) unsigned DEFAULT NULL,
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recommendation_colours_recommendation_id_foreign` (`recommendation_id`),
  CONSTRAINT `recommendation_colours_recommendation_id_foreign` FOREIGN KEY (`recommendation_id`) REFERENCES `recommendations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `recommendation_colours`
--

LOCK TABLES `recommendation_colours` WRITE;
/*!40000 ALTER TABLE `recommendation_colours` DISABLE KEYS */;
INSERT INTO `recommendation_colours` VALUES (1,1,'#F2F2F2','images/uploads/recommendations/2019/02/08/15496186025c5d4daaf2191.jpg',NULL),(2,1,'#FFA1D6','images/uploads/recommendations/2019/02/08/15496192455c5d502dc50bb.jpg',NULL),(3,1,'#60CEF0','images/uploads/recommendations/2019/02/08/15496193075c5d506b1aa38.jpg',NULL);
/*!40000 ALTER TABLE `recommendation_colours` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recommendation_products`
--

DROP TABLE IF EXISTS `recommendation_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recommendation_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `recommendation_colour_id` int(10) unsigned DEFAULT NULL,
  `admin_link_id` int(10) unsigned DEFAULT NULL,
  `price` double(8,2) NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `recommendation_products_recommendation_colour_id_foreign` (`recommendation_colour_id`),
  KEY `recommendation_products_admin_link_id_foreign` (`admin_link_id`),
  CONSTRAINT `recommendation_products_admin_link_id_foreign` FOREIGN KEY (`admin_link_id`) REFERENCES `admin_links` (`id`) ON DELETE SET NULL,
  CONSTRAINT `recommendation_products_recommendation_colour_id_foreign` FOREIGN KEY (`recommendation_colour_id`) REFERENCES `recommendation_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `recommendation_products`
--

LOCK TABLES `recommendation_products` WRITE;
/*!40000 ALTER TABLE `recommendation_products` DISABLE KEYS */;
INSERT INTO `recommendation_products` VALUES (1,1,4,125.00,'images/uploads/recommendations-products/2019/02/08/15496190565c5d4f70223ab.jpg','{\"absolute\":{\"x\":439,\"y\":207,\"width\":204,\"height\":306},\"relative\":{\"x\":36.15,\"width\":16.79,\"y\":22.47,\"height\":33.16}}'),(2,1,4,128.00,'images/uploads/recommendations-products/2019/02/08/15496190995c5d4f9b47329.jpg','{\"absolute\":{\"x\":411,\"y\":432,\"width\":200,\"height\":300},\"relative\":{\"x\":33.84,\"width\":16.47,\"y\":46.89,\"height\":32.52}}'),(3,2,7,125.00,'images/uploads/recommendations-products/2019/02/08/15496283155c5d739b59573.jpg','{\"absolute\":{\"x\":434,\"y\":200,\"width\":207,\"height\":310},\"relative\":{\"x\":35.72,\"width\":17.04,\"y\":21.67,\"height\":33.64}}'),(4,2,4,321.00,'images/uploads/recommendations-products/2019/02/08/15496283365c5d73b02f37e.jpg','{\"absolute\":{\"x\":665,\"y\":566,\"width\":152,\"height\":229},\"relative\":{\"x\":54.74,\"width\":12.59,\"y\":61.42,\"height\":24.86}}'),(6,3,7,23.00,'images/uploads/recommendations-products/2019/02/08/15496284465c5d741e6ec8b.jpg','{\"absolute\":{\"x\":509,\"y\":68,\"width\":100,\"height\":150},\"relative\":{\"x\":41.92,\"width\":8.23,\"y\":7.47,\"height\":16.25}}'),(7,3,4,211.00,'images/uploads/recommendations-products/2019/02/08/15496284665c5d7432121d4.jpg','{\"absolute\":{\"x\":407,\"y\":632,\"width\":100,\"height\":150},\"relative\":{\"x\":33.56,\"width\":8.23,\"y\":68.48,\"height\":16.25}}');
/*!40000 ALTER TABLE `recommendation_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recommendations`
--

DROP TABLE IF EXISTS `recommendations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recommendations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_link_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_on_main_page` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recommendations_admin_link_id_foreign` (`admin_link_id`),
  CONSTRAINT `recommendations_admin_link_id_foreign` FOREIGN KEY (`admin_link_id`) REFERENCES `admin_links` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `recommendations`
--

LOCK TABLES `recommendations` WRITE;
/*!40000 ALTER TABLE `recommendations` DISABLE KEYS */;
INSERT INTO `recommendations` VALUES (1,NULL,'היום בהמלצות  של בצל','בניגוד לטענה הרווחת, Lorem Ipsum אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות',1,'2019-02-08 07:19:29','2019-02-08 07:41:10');
/*!40000 ALTER TABLE `recommendations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_has_permissions`
--

DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_has_permissions`
--

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Administrator','web','2018-06-15 14:14:42','2018-06-15 14:14:42'),(2,'User','web','2018-06-15 14:14:42','2018-06-15 14:14:42');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shops`
--

DROP TABLE IF EXISTS `shops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shops` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `latitude` double(8,6) NOT NULL,
  `longitude` double(8,6) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shops_brand_id_foreign` (`brand_id`),
  CONSTRAINT `shops_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shops`
--

LOCK TABLES `shops` WRITE;
/*!40000 ALTER TABLE `shops` DISABLE KEYS */;
/*!40000 ALTER TABLE `shops` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sliders`
--

DROP TABLE IF EXISTS `sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sliders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `admin_link_id` int(10) unsigned DEFAULT NULL,
  `type` smallint(6) NOT NULL DEFAULT '1',
  `image_alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sliders_admin_link_id_foreign` (`admin_link_id`),
  CONSTRAINT `sliders_admin_link_id_foreign` FOREIGN KEY (`admin_link_id`) REFERENCES `admin_links` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sliders`
--

LOCK TABLES `sliders` WRITE;
/*!40000 ALTER TABLE `sliders` DISABLE KEYS */;
INSERT INTO `sliders` VALUES (1,'images/uploads/slider/2019/02/08/15496138125c5d3af414c57.jpg','voga בלוג','קבלו טיפים איך להתבש בכל יום וכל עונה',0,'2018-06-19 11:14:37','2019-02-08 06:16:55',3,1,'image alt'),(2,'images/uploads/slider/2018/06/19/15294198785b29186660974.jpg','כותרת שניה','קבלו טיפים איך להתבש בכל יום וכל עונה',1,'2018-06-19 11:51:23','2018-12-08 13:52:43',NULL,1,'image alt 2'),(4,'images/uploads/slider/2019/02/08/15496197365c5d5218b9860.jpg','חדשות עיקריות','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',0,'2019-02-08 07:55:39','2019-02-08 07:55:39',NULL,2,NULL),(6,'images/uploads/slider/2019/02/08/15496238685c5d623c9d215.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',0,'2019-02-08 09:02:10','2019-02-08 09:04:31',5,4,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין'),(7,'images/uploads/slider/2019/02/08/15496238915c5d625301856.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',0,'2019-02-08 09:03:27','2019-02-08 09:04:53',5,4,'טילדה סווינטון ואורחים נוספים בפסטיבל ברלין'),(8,'storage/slider/2019/02/08/15496242935c5d63e560f6f.jpg','חדשות עיקריות','בניגוד לטענה הרווחת, Lorem Ipsum אינו סתם טקסט רנדומלי. יש לו שורשים וחלקים מתוך הספרות הלטינית הקלאסית מאז 45 לפני הספירה. מה שהופך אותו',0,'2019-02-08 09:12:13','2019-02-08 09:12:48',6,3,'מבלוגים');
/*!40000 ALTER TABLE `sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscribes`
--

DROP TABLE IF EXISTS `subscribes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscribes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `events` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscribes`
--

LOCK TABLES `subscribes` WRITE;
/*!40000 ALTER TABLE `subscribes` DISABLE KEYS */;
INSERT INTO `subscribes` VALUES (1,'info@anvi.co.il','[\"all\"]','2018-12-08 14:07:01','2018-12-08 14:07:01'),(2,'xoovv3@gmail.com','[\"all\"]','2018-12-10 10:20:02','2018-12-10 10:20:02'),(3,'bogdantk1@gmail.com','[\"all\"]','2018-12-10 10:21:25','2018-12-10 10:21:25'),(4,'ss@aa.aa','[\"TATTOO:tag-1\",\"TATTOO:tag-2\"]','2019-02-10 13:54:51','2019-02-10 13:54:51');
/*!40000 ALTER TABLE `subscribes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tattoos`
--

DROP TABLE IF EXISTS `tattoos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tattoos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_alt` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_on_main_page` smallint(6) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tattoos`
--

LOCK TABLES `tattoos` WRITE;
/*!40000 ALTER TABLE `tattoos` DISABLE KEYS */;
INSERT INTO `tattoos` VALUES (1,'images/uploads/tattoos/2019/02/08/15496246325c5d653869536.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 07:58:12','2019-02-08 09:17:14'),(2,'images/uploads/tattoos/2019/02/08/15496246525c5d654c17ab8.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 07:59:02','2019-02-08 09:17:34'),(3,'images/uploads/tattoos/2019/02/08/15496246695c5d655d3ac9e.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 08:00:00','2019-02-08 09:17:51'),(4,'images/uploads/tattoos/2019/02/08/15496246845c5d656caf28d.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 08:03:03','2019-02-08 09:18:06'),(5,'images/uploads/tattoos/2019/02/08/15496246995c5d657b166b6.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 08:03:20','2019-02-08 09:18:23'),(6,'images/uploads/tattoos/2019/02/08/15496247485c5d65ac88799.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 08:03:41','2019-02-08 09:19:11'),(7,'images/uploads/tattoos/2019/02/08/15496247665c5d65be7196e.jpg','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין','טילדה סווינטון ואורחים נוספים בפסטיבל ברלין',1,'2019-02-08 08:04:38','2019-02-08 09:19:28');
/*!40000 ALTER TABLE `tattoos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'admin','admin@example.com','$2y$10$sbYQDouN2HQibxyA74EGyuUihHgePpgjzYQMkL7QcGRwP25hLPBMi','3wuLc5R38QGLLZr6a51SntZkkTdtnWftFCa299rZYAvgwzBxqXsn9QKCDeU9','2018-06-15 14:14:42','2018-06-15 14:14:42');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `video_sliders`
--

DROP TABLE IF EXISTS `video_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_sliders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `left_video` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `left_video_title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `right_video` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `right_video_title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `video_sliders`
--

LOCK TABLES `video_sliders` WRITE;
/*!40000 ALTER TABLE `video_sliders` DISABLE KEYS */;
INSERT INTO `video_sliders` VALUES (1,'usrq5Qn3YR0','בניגוד לטענה הרווח','CSWk-IIc9Yc','בניגוד לטענה הרווח',0,'2019-02-08 08:15:27','2019-02-09 12:17:37'),(2,'CSWk-IIc9Yc','84LBjXaeKk4','CSWk-IIc9Yc','84LBjXaeKk4',0,'2019-02-08 08:22:04','2019-02-08 08:40:39');
/*!40000 ALTER TABLE `video_sliders` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2020-02-23 20:24:56
